# BIOS Information
Write-Host "BIOS Information" -ForegroundColor Green
Get-WmiObject -Class Win32_BIOS | ForEach-Object {
    Write-Host "BIOS Manufacturer: " $_.Manufacturer
    Write-Host "BIOS Version: " $_.SMBIOSBIOSVersion
    Write-Host "BIOS Release Date: " $_.ReleaseDate
    Write-Host "BIOS Serial Number: " $_.SerialNumber
    Write-Host "BIOS SMBIOS Version: " $_.SMBIOSMajorVersion "." $_.SMBIOSMinorVersion
    Write-Host ""
}

# System Information
Write-Host "ComputerSystem Information" -ForegroundColor Green
Get-WmiObject -Class Win32_ComputerSystem | ForEach-Object {
    Write-Host "System Manufacturer: " $_.Manufacturer
    Write-Host "System Model: " $_.Model
    Write-Host "System Name: " $_.Name
    Write-Host "System Type: " $_.SystemType
    Write-Host "System Total Physical Memory: " ($_.TotalPhysicalMemory / 1GB -as [int]) "GB"
    Write-Host "System User: " $_.UserName
    Write-Host ""
}

# System Product Information
Write-Host "ComputerSystemProduct Information" -ForegroundColor Green
Get-WmiObject -Class Win32_ComputerSystemProduct | ForEach-Object {
    Write-Host "UUID: " $_.UUID
	Write-Host "Vendor: " $_.Vendor
	Write-Host "Name: " $_.Name
    Write-Host ""
}

# Baseboard (Motherboard) Information
Write-Host "Baseboard (Motherboard) Information" -ForegroundColor Green
Get-WmiObject -Class Win32_BaseBoard | ForEach-Object {
    Write-Host "Baseboard Manufacturer: " $_.Manufacturer
    Write-Host "Baseboard Product: " $_.Product
    Write-Host "Baseboard Version: " $_.Version
    Write-Host "Baseboard Serial Number: " $_.SerialNumber
    Write-Host "Baseboard Asset Tag: " $_.AssetTag
    Write-Host ""
}

# Processor Information
Write-Host "Processor Information" -ForegroundColor Green
Get-WmiObject -Class Win32_Processor | ForEach-Object {
    Write-Host "Processor Name: " $_.Name
    Write-Host "Processor Manufacturer: " $_.Manufacturer
    Write-Host "Processor Max Clock Speed: " $_.MaxClockSpeed "MHz"
    Write-Host "Processor Architecture: " $_.Architecture
    Write-Host "Processor Number of Cores: " $_.NumberOfCores
    Write-Host "Processor Number of Logical Processors: " $_.NumberOfLogicalProcessors
    Write-Host ""
}

# Memory Information
Write-Host "Memory Device Information" -ForegroundColor Green
Get-WmiObject -Class Win32_PhysicalMemory | ForEach-Object {
    Write-Host "Memory Capacity: " ($_.Capacity / 1GB -as [int]) "GB"
    Write-Host "Memory Speed: " $_.Speed "MHz"
    Write-Host "Memory Manufacturer: " $_.Manufacturer
    Write-Host "Memory Part Number: " $_.PartNumber
    Write-Host "Memory Serial Number: " $_.SerialNumber
    Write-Host "Memory Form Factor: " $_.FormFactor
    Write-Host ""
}

# Chassis Information
Write-Host "Chassis Information" -ForegroundColor Green
Get-WmiObject -Class Win32_SystemEnclosure | ForEach-Object {
    Write-Host "Chassis Manufacturer: " $_.Manufacturer
    Write-Host "Chassis Serial Number: " $_.SerialNumber
    Write-Host "Chassis Asset Tag: " $_.SMBIOSAssetTag
    Write-Host "Chassis Type: " $_.ChassisTypes
    Write-Host ""
}

Write-Host "Waiting 30 seconds ..."
Start-Sleep -Seconds 30
