<# :
  @echo off
    powershell /nologo /noprofile /command ^
        "&{[ScriptBlock]::Create((cat """%~f0""") -join [Char[]]10).Invoke(@(&{$args}%*))}"
  exit /b
#>

# Function to output the message in the right language
function Print-Message {
    param(
        [string]$lang,
        [string]$message
    )
    
    if ($lang -eq $language) {
        Write-Host "$message"
    }
}

# Function to create folder structure
function Create-FolderStructure {
    param(
        [string]$basePath,
        [string]$broker,
        [string]$serverType,
        [string]$accountType,
        [int]$accountNumber
    )

    $folderPath = Join-Path -Path $basePath -ChildPath "$broker\$serverType\$accountType\$accountNumber"
    
    # Check if the folder already exists
    if (-not (Test-Path $folderPath)) {
        # Create the folder structure and suppress the output
        New-Item -Path $folderPath -ItemType Directory -Force | Out-Null
    }
    
    Write-Host ""
    Print-Message "en" "Please use the following values in the MetaTrader Installer:"
    Print-Message "fr" "Veuillez utiliser les valeurs suivantes dans la fenetre d'installation de MetaTrader:"
    Write-Host ""
    Print-Message "en" "Installation Folder : $folderPath"
    Print-Message "en" "Shortcut Name       : MT5 $broker $serverType $accountType $accountNumber"
    
    Print-Message "fr" "Dossier d'installation : $folderPath"
    Print-Message "fr" "Nom du raccourci       : MT5 $broker $serverType $accountType $accountNumber"
    Write-Host ""
}

# Prompt user to select language
do {
    $language = Read-Host "Please select the language / Veuillez saisir la langue (en/fr)" -ErrorAction SilentlyContinue
    $language = $language.ToLower()
} until ($language -eq "en" -or $language -eq "fr")

# Main script
# Define predefined choices
$brokerChoices = @("PUPrime", "VantageMarkets", "FusionMarkets", "MonetaMarkets")
$serverTypeChoices = @("Real", "Demo")
$accountTypeChoices = @{
    "PUPrime" = @("ECN", "Prime", "PrimeCent")
    "VantageMarkets" = @("Raw", "Pro")
    "FusionMarkets" = @("Zero")
    "MonetaMarkets" = @("Ultra", "Prime")
}

# Prompt user for broker choice
do {
    if ($language -eq "fr") {
        $brokerInput = Read-Host "Saisir le nom du broker ($($brokerChoices -join '/'))"
    }
    else {
        $brokerInput = Read-Host "Enter broker name ($($brokerChoices -join '/'))"
    }
    $broker = $brokerChoices | Where-Object { $_ -eq $brokerInput.ToUpper() }
} until ($broker)

# Prompt user for server type choice
do {
    if ($language -eq "fr") {
        $serverTypeInput = Read-Host "Saisir le type de serveur ($($serverTypeChoices -join '/'))"
    }
    else {
        $serverTypeInput = Read-Host "Enter server type ($($serverTypeChoices -join '/'))"
    }
    $serverType = $serverTypeChoices | Where-Object { $_ -eq $serverTypeInput.ToUpper() }
} until ($serverType)

# Prompt user for account type choice based on selected broker
do {
    if ($language -eq "fr") {
        $accountTypeInput = Read-Host "Saisir le type de compte ($($accountTypeChoices[$broker] -join '/'))"
    }
    else {
        $accountTypeInput = Read-Host "Enter account type ($($accountTypeChoices[$broker] -join '/'))"
    }
    $accountType = $accountTypeChoices[$broker] | Where-Object { $_ -eq $accountTypeInput.ToUpper() }
} until ($accountType)

# Prompt user for account number
do {
    if ($language -eq "fr") {
        [int]$accountNumber = Read-Host "Saisir le numero de compte "
    }
    else {
        [int]$accountNumber = Read-Host "Enter account number "
    }
} until ($accountNumber -gt 0)  # Ensure the entered number is positive

# Create new line
Write-Host ""

# Define base path
$basePath = "C:\Program Files\MetaTrader5"

# Call function to create folder structure
Create-FolderStructure -basePath $basePath -broker $broker -serverType $serverType -accountType $accountType -accountNumber $accountNumber

# Wait for user to press Enter to exit
Print-Message "en" "Press Enter to exit..."
Print-Message "fr" "Appuyer sur Entree pour fermer..."
$null = Read-Host
