<# :
  @echo off
    powershell /nologo /noprofile /command ^
        "&{[ScriptBlock]::Create((cat """%~f0""") -join [Char[]]10).Invoke(@(&{$args}%*))}"
  exit /b
#>

# Function to output the message in the right language
function Print-Message {
    param(
        [string]$lang,
        [string]$message
    )
    
    if ($lang -eq $language) {
        Write-Host "$message"
    }
}

# Function to check if Git for Windows is installed
function Is-GitInstalled {
    return (Test-Path "C:\Program Files\Git\bin\git.exe" -PathType Leaf)
}

# Function to download file
function Download-File {
    param(
        [string]$url,
        [string]$outputFile
    )

    $webClient = New-Object System.Net.WebClient
    $webClient.DownloadFile($url, $outputFile)
}

# Function to install Git for Windows
function Install-Git {
    param(
        [string]$installerPath,
        [string]$optionsFile
    )

    Start-Process -FilePath $installerPath -ArgumentList "/VERYSILENT", "/NORESTART", "/NOCANCEL", "/LOADINF=$optionsFile" -Wait
}

# Prompt user to select language
do {
    $language = Read-Host "Please select the language / Veuillez saisir la langue (en/fr)" -ErrorAction SilentlyContinue
    $language = $language.ToLower()
} until ($language -eq "en" -or $language -eq "fr")

# Main script
if (Is-GitInstalled) {
    Print-Message "en" "Git for Windows is already installed."
    Print-Message "fr" "Git pour Windows est deja installe."
}
else {
    # Define URL for latest version of Git for Windows installer
    $gitUrl = "https://github.com/git-for-windows/git/releases/download/v2.47.0.windows.2/Git-2.47.0.2-64-bit.exe"

    # Define download path for Git for Windows installer
    $downloadPath = "$env:TEMP\GitInstaller.exe"

    # Download Git for Windows installer
    Print-Message "en" "Downloading Git for Windows installer from $gitUrl ..."
    Print-Message "fr" "Telechargement de l'installeur Git pour Windows depuis $gitUrl ..."
    Download-File -url $gitUrl -outputFile $downloadPath

    # Path to options file
    $optionsFile = "files\git_options.ini"

    # Install Git for Windows
    Print-Message "en" "Installing Git for Windows, please wait ..."
    Print-Message "fr" "Installation de Git pour Windows, veuillez patienter ..."
    Install-Git -installerPath $downloadPath -optionsFile $optionsFile

    # Wait 2 seconds
    Start-Sleep -Seconds 2

    # Verify if the installation was successful
    if (Is-GitInstalled) {
        Print-Message "en" "Git for Windows has been installed successfully."
        Print-Message "fr" "Git pour Windows a ete installe avec succes."
    }
    else {
        Print-Message "en" "An error happened during Git for Windows installation."
        Print-Message "fr" "Une erreur s'est produite durant l'installation de Git pour Windows."
    }
}

# Define the folder path
$usrbinFolderPath = "C:\Program Files\Git\usr\bin"

# Check if the folder exists
if (Test-Path -Path $usrbinFolderPath -PathType Container) {

    # Define the URL for downloading jq
    $downloadUrl = "https://github.com/jqlang/jq/releases/latest/download/jq-win64.exe"

    # Define the path for saving jq.exe
    $jqExePath = Join-Path -Path $usrbinFolderPath -ChildPath "jq.exe"

    # Download jq.exe if it doesn't already exist
    if (-not (Test-Path -Path $jqExePath -PathType Leaf)) {
        Print-Message "en" "Downloading jq.exe from $downloadUrl"
        Print-Message "fr" "Telechargement de jq.exe depuis $downloadUrl"
        # Invoke-WebRequest -Uri $downloadUrl -OutFile $jqExePath
        Download-File -url $downloadUrl -outputFile $jqExePath

        # Check if download was successful
        if (Test-Path -Path $jqExePath -PathType Leaf) {
            Print-Message "en" "jq.exe has been downloaded and installed in $jqExePath."
            Print-Message "fr" "jq.exe a ete telecharge et installe dans $jqExePath."
        }
        else {
            Print-Message "en" "Error, unable to download jq.exe"
            Print-Message "fr" "Erreur, impossible de telecharger jq.exe"
        }
    }
    else {
        Print-Message "en" "jq.exe is already installed in $jqExePath."
        Print-Message "fr" "jq.exe est deja installe dans $jqExePath."
    }
}
else {
    Write-Host "Unable to install jq.exe because the folder $usrbinFolderPath does not exist."
}


# Pause for 5 seconds
Print-Message "en" "This window will close automatically in 5 seconds ..."
Print-Message "fr" "Cette fenetre se fermera automatiquement dans 5 secondes ..."
Start-Sleep -Seconds 5
