<# :
  @echo off
    powershell /nologo /noprofile /command ^
        "&{[ScriptBlock]::Create((cat """%~f0""") -join [Char[]]10).Invoke(@(&{$args}%*))}"
  exit /b
#>

# Function to output the message in the right language
function Print-Message {
    param(
        [string]$lang,
        [string]$message
    )
    
    if ($lang -eq $language) {
        Write-Host "$message"
    }
}

# Function to check if Python is installed
function Is-PythonInstalled {
	if (Test-Path "$env:LOCALAPPDATA\Programs\Python\Python311\python.exe" -PathType Leaf) {
		return $true
	}
	elseif (Test-Path "$env:LOCALAPPDATA\Programs\Python\Python312\python.exe" -PathType Leaf) {
		return $true
	}
	return $false
}

# Function to download file
function Download-File {
    param(
        [string]$url,
        [string]$outputFile
    )

    $webClient = New-Object System.Net.WebClient
    $webClient.DownloadFile($url, $outputFile)
}

# Function to install Python
function Install-Python {
    param(
        [string]$installerPath
    )

    # Python installer arguments
    $installArgs = "/quiet", "/norestart", "/log", "$env:TEMP\python_install.log", "PrependPath=1"

    # Start the installer
    Start-Process -FilePath $installerPath -ArgumentList $installArgs -Wait -WindowStyle Hidden
}

# Prompt user to select language
do {
    $language = Read-Host "Please select the language / Veuillez saisir la langue (en/fr)" -ErrorAction SilentlyContinue
    $language = $language.ToLower()
} until ($language -eq "en" -or $language -eq "fr")

# Main script
if (Is-PythonInstalled) {
    Print-Message "en" "Python is already installed."
    Print-Message "fr" "Python est deja installe."
}
else {
    # Define URL for Python installer
    $pythonUrl = "https://www.python.org/ftp/python/3.13.0/python-3.13.0-amd64.exe"

    # Define download path for Python installer
    $downloadPath = "$env:TEMP\PythonInstaller.exe"

    # Download Python installer
    Print-Message "en" "Downloading Python installer from $pythonUrl ..."
    Print-Message "fr" "Telechargement de l'installeur Python depuis $pythonUrl ..."
    Download-File -url $pythonUrl -outputFile $downloadPath

    # Install Python
    Print-Message "en" "Installing Python, please wait ..."
    Print-Message "fr" "Installation de Python, veuillez patienter ..."
    Install-Python -installerPath $downloadPath

    # Wait 2 seconds
    Start-Sleep -Seconds 2

    # Verify if the installation was successful
    if (Is-PythonInstalled) {
        Print-Message "en" "Python has been installed successfully."
        Print-Message "fr" "Python a ete installe avec succes."
    }
    else {
        Print-Message "en" "An error happened during Python installation."
        Print-Message "fr" "Une erreur s'est produite durant l'installation de Python."
    }
}

# Define the name and value of the environment variable
$envName = "PYTHONUNBUFFERED"
$envValue = "true"
$scope = "Machine"  # "User" or "Machine" Use 'Machine' for system-wide variables, requires admin rights

# Check if the environment variable already exists
if ([System.Environment]::GetEnvironmentVariable($envName, $scope) -eq $null) {
    # Environment variable does not exist, so create it
    [System.Environment]::SetEnvironmentVariable($envName, $envValue, $scope)
    Print-Message "en" "Adding Environment Variable '$envName' with value '$envValue'."
	Print-Message "fr" "Ajout de la Variable d'Environment '$envName' avec la valeur '$envValue'."
} else {
    # Environment variable exists
	$currentValue = $([System.Environment]::GetEnvironmentVariable($envName, $scope))
    Print-Message "en" "The Environment Variable '$envName' already exists with value '$currentValue'."
	Print-Message "fr" "La Variable d'Environment '$envName' existe deja avec la valeur '$currentValue'."
}

# Pause for 5 seconds
Print-Message "en" "This window will close automatically in 5 seconds ..."
Print-Message "fr" "Cette fenetre se fermera automatiquement dans 5 secondes ..."
Start-Sleep -Seconds 5
