#!/bin/bash

IP_INFO_URL="https://ipinfo.io/"

if [[ -z $( which jq 2>/dev/null ) ]]; then
    echo "ERROR - JQ is not installed. Please install it using:"
    echo "curl --silent -L -o /usr/bin/jq.exe https://github.com/stedolan/jq/releases/latest/download/jq-win64.exe"
	sleep 10
    exit 1
fi

IP_INFO_JSON=$( curl --silent "$IP_INFO_URL" 2>/dev/null )

# echo "$IP_INFO_JSON"

CITY=$( echo "$IP_INFO_JSON" | jq -r ".city" 2>/dev/null | sed -e "s|City of ||g" | awk '{print $1}' )
COUNTRY=$( echo "$IP_INFO_JSON" | jq -r ".country" 2>/dev/null | awk '{print $1}' )
ORG_FULL=$( echo "$IP_INFO_JSON" | jq -r ".org" 2>/dev/null )
CLOUD=$( echo "$ORG_FULL" | awk '{print $2}' )

# Improve some city names
if [[ "$CITY" == "Secaucus" ]]; then
    CITY="NewYork"
elif [[ "$CITY" == "Bexley" ]]; then
	CITY="London"
fi

# Improve some country names
if [[ "$COUNTRY" == "GB" ]]; then
    COUNTRY="UK"
elif [[ "$COUNTRY" == "US" ]]; then
    COUNTRY="USA"
fi

if [[ "$CITY" == "" ]]; then
    echo "Error, unable to detect the City."
    exit 1
fi

if [[ "$COUNTRY" == "" ]]; then
    echo "Error, unable to detect the Country."
    exit 1
fi

if [[ "$CLOUD" == "" ]]; then
    echo "Error, unable to detect the Cloud Provider."
    exit 1
fi

echo "Detected the following information:"
echo "Location: $CITY, $COUNTRY"
echo "CloudProvider: $CLOUD"
echo "Model: <Unknown>"

echo -n "$CITY, $COUNTRY" > Location.txt
echo -n "$CLOUD" > CloudProvider.txt
echo -n "<Unknown>" > Model.txt

echo ""
echo "Exported VPS Location to Location.txt and Cloud Provider to CloudProvider.txt"

echo "Sleeping 10 seconds and exiting."
sleep 10

