' Create WMI service connection
Set objWMIService = GetObject("winmgmts:\\.\root\cimv2")

' Initialize variables
platform = "Unknown Platform"

' Query Win32_ComputerSystem for Manufacturer and Model
If platform = "Unknown Platform" Then
	Set systemInfo = objWMIService.ExecQuery("SELECT Manufacturer, Model FROM Win32_ComputerSystem")
	For Each system In systemInfo
		systemManufacturer = system.Manufacturer
		systemModel = system.Model
		manufacturer = LCase(system.Manufacturer)
		model = LCase(system.Model)
		
		If InStr(manufacturer, "microsoft") > 0 And InStr(model, "hyper-v") > 0 Then
			platform = "Hyper-V"
		ElseIf InStr(manufacturer, "vmware") > 0 Then
			platform = "VMware"
		ElseIf InStr(manufacturer, "bochs") > 0 And InStr(model, "bxpc") > 0 Then
			platform = "QEMU"
		ElseIf InStr(manufacturer, "qemu") > 0 Then
			platform = "QEMU"
		ElseIf InStr(manufacturer, "amazon") > 0 Or InStr(model, "ec2") > 0 Then
			platform = "AWS"
		ElseIf InStr(manufacturer, "google") > 0 Then
			platform = "Google Cloud"
		ElseIf InStr(manufacturer, "xen") > 0 Then
			platform = "Xen"
		End If
	Next
End If

' Query Win32_ComputerSystemProduct for Vendor and Name if still unknown
If platform = "Unknown Platform" Then
    Set productInfo = objWMIService.ExecQuery("SELECT Vendor, Name FROM Win32_ComputerSystemProduct")
    For Each product In productInfo
        vendor = LCase(product.Vendor)
        name = LCase(product.Name)
        
        If InStr(vendor, "microsoft") > 0 And InStr(name, "hyper-v") > 0 Then
            platform = "Hyper-V"
        ElseIf InStr(vendor, "vmware") > 0 Then
            platform = "VMware"
        ElseIf InStr(vendor, "amazon") > 0 Or InStr(name, "ec2") > 0 Then
            platform = "AWS"
        ElseIf InStr(vendor, "google") > 0 Then
            platform = "Google Cloud"
        ElseIf InStr(vendor, "xen") > 0 Then
            platform = "Xen"
		ElseIf InStr(vendor, "qemu") > 0 Then
			platform = "QEMU"
        End If
    Next
End If

' Fallback to the System Model value
If platform = "Unknown Platform" Then
	platform = systemModel
End If

' Output the detected platform
Echo platform
