' Create WMI service connection
Set objWMIService = GetObject("winmgmts:\\.\root\cimv2")

' Get the number of CPUs (logical processors)
Set colProcessors = objWMIService.ExecQuery("SELECT NumberOfLogicalProcessors FROM Win32_Processor")
cpuCount = 0
For Each objProcessor In colProcessors
    cpuCount = cpuCount + objProcessor.NumberOfLogicalProcessors
Next

' Get total physical memory (in bytes) and convert to GB
Set colComputerSystems = objWMIService.ExecQuery("SELECT TotalPhysicalMemory FROM Win32_ComputerSystem")
totalMemoryGB = 0
For Each objComputer In colComputerSystems
    totalMemoryGB = Round(objComputer.TotalPhysicalMemory / 1073741824, 0) ' Convert bytes to GB
Next

' Get total disk size (in bytes) and convert to GB
Set colDisks = objWMIService.ExecQuery("SELECT Size FROM Win32_DiskDrive")
totalDiskSizeGB = 0
For Each objDisk In colDisks
    totalDiskSizeGB = totalDiskSizeGB + objDisk.Size
Next
totalDiskSizeGB = Round(totalDiskSizeGB / 1073741824, 0) ' Convert bytes to GB

' Combine the results into the desired format
result = cpuCount & " CPU, " & totalMemoryGB & "GB RAM, " & totalDiskSizeGB & "GB HDD"

' Output the result (BGInfo captures this output)
Echo result
