<# :
  @echo off
    powershell /nologo /noprofile /command ^
        "&{[ScriptBlock]::Create((cat """%~f0""") -join [Char[]]10).Invoke(@(&{$args}%*))}"
  exit /b
#>

# Function to output the message in the right language
function Print-Message {
    param(
        [string]$lang,
        [string]$message
    )
    
    if ($lang -eq $language) {
        Write-Host "$message"
    }
}

# Function to check if BGInfo is installed
function Is-BGInfoInstalled {
    return (Test-Path "C:\Tools\BGInfo\Bginfo.exe" -PathType Leaf)
}

# Function to download file
function Download-File {
    param(
        [string]$url,
        [string]$outputFile
    )

    $webClient = New-Object System.Net.WebClient
    $webClient.DownloadFile($url, $outputFile)
}

# Function to install BGInfo
function Install-BGInfo {
    param(
        [string]$installerPath,
        [string]$installDirectory
    )

    # Create directory if it does not exist
    if (-not (Test-Path $installDirectory)) {
        New-Item -ItemType Directory -Force -Path $installDirectory | Out-Null
    }

    # Extract BGInfo files to install directory
    Expand-Archive -Path $installerPath -DestinationPath $installDirectory -Force

    # Verify if the installation was successful
    if (Is-BGInfoInstalled) {
        Print-Message "en" "BGInfo has been installed successfully."
        Print-Message "fr" "BGInfo a ete installe avec succes."
    }
    else {
        Print-Message "en" "An error happened during BGInfo installation."
        Print-Message "fr" "Une erreur s'est produite durant l'installation de BGInfo."
    }
}

# Function to copy a file
function Copy-File {
    param(
        [string]$sourceFile,
        [string]$destinationDirectory
    )

    Copy-Item -Path "$sourceFile" -Destination "$destinationDirectory" -Force
}

# Function to retrieve IP information from ipinfo.io
function Get-IPInfo {
    Print-Message "en" "Detecting information about this server ..."
    Print-Message "fr" "Detection des informations de ce serveur ..."
    $ipInfo = Invoke-RestMethod -Uri "https://ipinfo.io/" -UseBasicParsing
    return $ipInfo
}

# Function to save IP information to files
function Save-IPInfoToFile {
    param(
        [string]$city,
        [string]$country,
        [string]$org
    )

    # Remove AS number from org
    $orgWithoutAS = $org -replace '^AS[0-9]+\s', ''

    $cityCountryContent = "$city, $country"
    $orgContent = "$orgWithoutAS"

    Print-Message "en" "Location: $city, $country"
    Print-Message "en" "CloudProvider: $orgWithoutAS"

    Print-Message "fr" "Lieu: $city, $country"
    Print-Message "fr" "CloudProvider: $orgWithoutAS"

    $locationFilePath = "C:\Tools\BGInfo\Location.txt"
    $cloudProviderFilePath = "C:\Tools\BGInfo\CloudProvider.txt"

    $cityCountryContent | Out-File -FilePath $locationFilePath -Encoding ascii -Force -NoNewline
    $orgContent | Out-File -FilePath $cloudProviderFilePath -Encoding ascii -Force -NoNewline
}

# Function to export the username to a file
function Export-UsernameToFile {
    Print-Message "en" "Please type your firstname:"
    Print-Message "fr" "Veuillez saisir votre prenom:"
    $currentUserName = Read-Host

    if (Test-Path "C:\Tools\BGInfo\Owner.txt") {
        Print-Message "en" "The file C:\Tools\BGInfo\Owner.txt is already present. You can edit it manually to change the username."
        Print-Message "fr" "Le fichier C:\Tools\BGInfo\Owner.txt existe deja. Vous pouvez l'editer manuellement pour changer l'utilisateur."
    }
    else {
        $currentUserName | Out-File -FilePath "C:\Tools\BGInfo\Owner.txt" -Encoding ascii -Force -NoNewline
    }
}

# Function to import a task from an XML file into Task Scheduler
function Import-TaskFromXml {
    param(
        [string]$xmlFilePath,
        [string]$taskName
    )

    # Check if the XML file exists
    if (-not (Test-Path $xmlFilePath)) {
        Print-Message "en" "Error, XML file not found at path: $xmlFilePath"
        Print-Message "fr" "Erreur, impossible de trouver le fichier XML: $xmlFilePath"
        return
    }

    # Attempt to unregister the task if it already exist
    try {
        Unregister-ScheduledTask -TaskName $taskName -Confirm:$false -ErrorAction Stop
    }
    catch {}

    # Import the task from the XML file
    Print-Message "en" "Importing the Scheduled Task from the XML file."
    Print-Message "fr" "Import de la Tache Planifiee depuis le fichier XML"
    Register-ScheduledTask -Xml (Get-Content $xmlFilePath -Raw) -TaskName $taskName -TaskPath "\" | Out-Null
}

# Prompt user to select language
do {
    $language = Read-Host "Please select the language / Veuillez saisir la langue (en/fr)" -ErrorAction SilentlyContinue
    $language = $language.ToLower()
} until ($language -eq "en" -or $language -eq "fr")

# Main script

$installDirectory = "C:\Tools\BGInfo"

# Create the installDirectory
New-Item -ItemType Directory -Path "$installDirectory"

# Install BGInfo if not already installed
if (Is-BGInfoInstalled) {
    Print-Message "en" "BGInfo is already installed."
    Print-Message "fr" "BGInfo est deja installe."
}
else {
    # Define URL for BGInfo installer
    $bginfoUrl = "https://download.sysinternals.com/files/BGInfo.zip"

    # Define download path for BGInfo installer
    $downloadPath = "$env:TEMP\BGInfo.zip"

    # Download BGInfo installer
    Print-Message "en" "Downloading BGInfo installer from $bginfoUrl ..."
    Print-Message "fr" "Telechargement du fichier d'installation de BGInfo depuis $bginfoUrl ..."
    Download-File -url $bginfoUrl -outputFile $downloadPath

    # Install BGInfo
    Print-Message "en" "Installing BGInfo ..."
    Print-Message "fr" "Installation de BGInfo ..."
    Install-BGInfo -installerPath $downloadPath -installDirectory $installDirectory
}

# Save the username to the file Owner.txt
Export-UsernameToFile

# Retrieve IP information from ipinfo.io
$ipInfo = Get-IPInfo

# Save IP information to files
Save-IPInfoToFile -city $ipInfo.city -country $ipInfo.country -org $ipInfo.org

# Define the path to the XML file containing the task definition
$xmlFilePath = "files\task_scheduler.xml"

if (Test-Path "$xmlFilePath") {
    # Specify the task name
    $taskName = "BGInfo-Refresh"

    # Import the task from the XML file into Task Scheduler
    Import-TaskFromXml -xmlFilePath $xmlFilePath -taskName $taskName

    # Run the task
    Start-ScheduledTask -TaskName "$taskName"
}
else {
    Print-Message "en" "Error, unable to find the XML file $xmlFilePath ..."
    Print-Message "fr" "Erreur, impossible de trouver le fichier XML $xmlFilePath ..."
}

Print-Message "en" "Copying the config.bgi file ..."
Print-Message "fr" "Copie du fichier config.bgi ..."

# Copy config.bgi file
$fileToCopy = Join-Path -Path "$PWD" -ChildPath "files\config.bgi"
if (Test-Path "$fileToCopy") {
    Copy-File -sourceFile "$fileToCopy" -destinationDirectory "$installDirectory"
}
else {
    Print-Message "en" "Error, the file $fileToCopy was not found."
    Print-Message "fr" "Erreur, le fichier $fileToCopy est introuvable."
}

Print-Message "en" "Copying the HardwareInfo.vbs file ..."
Print-Message "fr" "Copie du fichier HardwareInfo.vbs ..."

# Copy HardwareInfo.vbs file
$fileToCopy = Join-Path -Path "$PWD" -ChildPath "files\HardwareInfo.vbs"
if (Test-Path "$fileToCopy") {
    Copy-File -sourceFile "$fileToCopy" -destinationDirectory "$installDirectory"
}
else {
    Print-Message "en" "Error, the file $fileToCopy was not found."
    Print-Message "fr" "Erreur, le fichier $fileToCopy est introuvable."
}

Print-Message "en" "Copying the PlatformInfo.vbs file ..."
Print-Message "fr" "Copie du fichier PlatformInfo.vbs ..."

# Copy PlatformInfo.vbs file
$fileToCopy = Join-Path -Path "$PWD" -ChildPath "files\PlatformInfo.vbs"
if (Test-Path "$fileToCopy") {
    Copy-File -sourceFile "$fileToCopy" -destinationDirectory "$installDirectory"
}
else {
    Print-Message "en" "Error, the file $fileToCopy was not found."
    Print-Message "fr" "Erreur, le fichier $fileToCopy est introuvable."
}


# Call the BgInfo to refresh the background
if (Test-Path "$installDirectory\Bginfo64.exe") {
    Start-Process -FilePath $installDirectory\Bginfo64.exe -ArgumentList "$installDirectory\config.bgi /silent /timer:0 /nolicprompt" -Wait
}

# Pause for 5 seconds
Print-Message "en" "This window will close automatically in 5 seconds ..."
Print-Message "fr" "Cette fenetre se fermera automatiquement dans 5 secondes ..."
Start-Sleep -Seconds 5