<# :
  @echo off
    powershell /nologo /noprofile /command ^
        "&{[ScriptBlock]::Create((cat """%~f0""") -join [Char[]]10).Invoke(@(&{$args}%*))}"
  exit /b
#>

# Function to output the message in the right language
function Print-Message {
    param(
        [string]$lang,
        [string]$message
    )
    
    if ($lang -eq $language) {
        Write-Host "$message"
    }
}

# Function to check if Notepad++ is installed
function Is-NotepadPlusPlusInstalled {
    return (Test-Path "C:\Program Files (x86)\Notepad++\notepad++.exe" -PathType Leaf)
}

# Function to download file
function Download-File {
    param(
        [string]$url,
        [string]$outputFile
    )

    $webClient = New-Object System.Net.WebClient
    $webClient.DownloadFile($url, $outputFile)
}

# Function to install Notepad++
function Install-NotepadPlusPlus {
    param(
        [string]$installerPath
    )

    Start-Process -FilePath $installerPath -ArgumentList "/S" -Wait
}

# Prompt user to select language
do {
    $language = Read-Host "Please select the language / Veuillez saisir la langue (en/fr)" -ErrorAction SilentlyContinue
    $language = $language.ToLower()
} until ($language -eq "en" -or $language -eq "fr")

# Main script
if (Is-NotepadPlusPlusInstalled) {
    Print-Message "en" "Notepad++ is already installed."
    Print-Message "fr" "Notepad++ est deja installe."
}
else {
    # Define URL for latest version of Notepad++ installer
    $notepadPlusPlusUrl = "https://github.com/notepad-plus-plus/notepad-plus-plus/releases/download/v8.7.1/npp.8.7.1.Installer.x64.exe"

    # Define download path for Notepad++ installer
    $downloadPath = "$env:TEMP\NotepadPlusPlusInstaller.exe"

    # Download Notepad++ installer
    Print-Message "en" "Downloading Notepad++ installer from $notepadPlusPlusUrl ..."
    Print-Message "fr" "Telechargement de l'installeur Notepad++ depuis $notepadPlusPlusUrl ..."
    Download-File -url $notepadPlusPlusUrl -outputFile $downloadPath

    # Install Notepad++
    Print-Message "en" "Installing Notepad++, please wait ..."
    Print-Message "fr" "Installation de Notepad++, veuillez patienter ..."
    Install-NotepadPlusPlus -installerPath $downloadPath

    # Wait 2 seconds
    Start-Sleep -Seconds 2

    # Verify if the installation was successful
    if (Is-NotepadPlusPlusInstalled) {
        Print-Message "en" "Notepad++ has been installed successfully."
        Print-Message "fr" "Notepad++ a ete installe avec succes."
    }
    else {
        Print-Message "en" "An error happened during Notepad++ installation."
        Print-Message "fr" "Une erreur s'est produite durant l'installation de Notepad++."
    }
}

# Pause for 5 seconds
Print-Message "en" "This window will close automatically in 5 seconds ..."
Print-Message "fr" "Cette fenetre se fermera automatiquement dans 5 secondes ..."
Start-Sleep -Seconds 5
