<# :
  @echo off
    powershell /nologo /noprofile /command ^
        "&{[ScriptBlock]::Create((cat """%~f0""") -join [Char[]]10).Invoke(@(&{$args}%*))}"
  exit /b
#>

# Function to output the message in the right language
function Print-Message {
    param(
        [string]$lang,
        [string]$message    
    )
    
    if ($lang -eq $language) {
        Write-Host "$message"
    }
}

# Function to check if EZWinBan is installed
function Is-EZWinBanInstalled {
    return (Test-Path "C:\Program Files\EZWinBan\process.ps1" -PathType Leaf)
}

# Function to download file
function Download-File {
    param(
        [string]$url,
        [string]$outputFile
    )

    $webClient = New-Object System.Net.WebClient
    $webClient.DownloadFile($url, $outputFile)
}

# Function to install EZWinBan
function Install-EZWinBan {
    param(
        [string]$installerPath
    )

    Start-Process -FilePath $installerPath -ArgumentList "/VERYSILENT", "/NORESTART", "/NOCANCEL"
}

# Prompt user to select language
do {
    $language = Read-Host "Please select the language / Veuillez saisir la langue (en/fr)" -ErrorAction SilentlyContinue
    $language = $language.ToLower()
} until ($language -eq "en" -or $language -eq "fr")

# Main script
if (Is-EZWinBanInstalled) {
    Print-Message "en" "EZWinBan is already installed."
    Print-Message "fr" "EZWinBan est deja installe."
}
else {
    # Define URL for latest version of EZWinBan installer
    $installerUrl = "https://github.com/neil-sabol/EZWinBan/releases/download/v3.1.0/EZWinBan-Install.exe"

    # Define download path for EZWinBan installer
    $downloadPath = "$env:TEMP\GitInstaller.exe"

    # Download EZWinBan installer
    Print-Message "en" "Downloading EZWinBan installer from $installerUrl ..."
    Print-Message "fr" "Telechargement de l'installeur EZWinBan depuis $installerUrl ..."
    Download-File -url $installerUrl -outputFile $downloadPath

    # Install EZWinBan
    Print-Message "en" "Installing EZWinBan ..."
    Print-Message "fr" "Installation de EZWinBan ..."
    Install-EZWinBan -installerPath $downloadPath

    # Wait 2 seconds
    Start-Sleep -Seconds 2

    # Verify if the installation was successful
    if (Is-EZWinBanInstalled) {
        Print-Message "en" "EZWinBan has been installed successfully."
        Print-Message "fr" "EZWinBan a ete installe avec succes."
    }
    else {
        Print-Message "en" "An error happened during EZWinBan installation."
        Print-Message "fr" "Une erreur s'est produite durant l'installation de EZWinBan."
    }
}

# Pause for 5 seconds
Print-Message "en" "This window will close automatically in 5 seconds ..."
Print-Message "fr" "Cette fenetre se fermera automatiquement dans 5 secondes ..."
Start-Sleep -Seconds 5
