<# :
  @echo off
    powershell /nologo /noprofile /command ^
        "&{[ScriptBlock]::Create((cat """%~f0""") -join [Char[]]10).Invoke(@(&{$args}%*))}"
  exit /b
#>

# Function to output the message in the right language
function Print-Message {
    param(
        [string]$lang,
        [string]$message
    )
    
    if ($lang -eq $language) {
        Write-Host "$message"
    }
}

# Function to check if 7-Zip is installed
function Is-7ZipInstalled {
    return (Test-Path "C:\Program Files\7-Zip\7z.exe" -PathType Leaf)
}

# Function to download file
function Download-File {
    param(
        [string]$url,
        [string]$outputFile
    )

    $webClient = New-Object System.Net.WebClient
    $webClient.DownloadFile($url, $outputFile)
}

# Function to install 7-Zip
function Install-7Zip {
    param(
        [string]$installerPath
    )

    Start-Process -FilePath $installerPath -ArgumentList "/S" -Wait
}

# Prompt user to select language
do {
    $language = Read-Host "Please select the language / Veuillez saisir la langue (en/fr)" -ErrorAction SilentlyContinue
    $language = $language.ToLower()
} until ($language -eq "en" -or $language -eq "fr")


# Main script
if (Is-7ZipInstalled) {
    Print-Message "en" "7-Zip is already installed."
    Print-Message "fr" "7-Zip est deja installe."
}
else {
    # Define URL for latest version of 7-Zip installer
    $sevenZipUrl = "https://www.7-zip.org/a/7z2408-x64.exe"

    # Define download path for 7-Zip installer
    $downloadPath = "$env:TEMP\7ZipInstaller.exe"

    # Download 7-Zip installer
    Print-Message "en" "Downloading 7-Zip installer from $sevenZipUrl ..."
    Print-Message "fr" "Telechargement de l'installeur 7-Zip depuis $sevenZipUrl ..."
    Download-File -url $sevenZipUrl -outputFile $downloadPath

    # Install 7-Zip
    Print-Message "en" "Installing 7-Zip, please wait ..."
    Print-Message "fr" "Installation de 7-Zip, veuillez patienter ..."
    Install-7Zip -installerPath $downloadPath

    # Wait 2 seconds
    Start-Sleep -Seconds 2

    # Verify if the installation was successful
    if (Is-7ZipInstalled) {
        Print-Message "en" "7-Zip has been installed successfully."
        Print-Message "fr" "7-Zip a ete installe avec succes."
    }
    else {
        Print-Message "en" "An error happened during 7-Zip installation."
        Print-Message "fr" "Une erreur s'est produite durant l'installation de 7-Zip."
    }
}

# Pause for 5 seconds
Print-Message "en" "This window will close automatically in 5 seconds ..."
Print-Message "fr" "Cette fenetre se fermera automatiquement dans 5 secondes ..."
Start-Sleep -Seconds 5
