<# :
  @echo off
    powershell /nologo /noprofile /command ^
        "&{[ScriptBlock]::Create((cat """%~f0""") -join [Char[]]10).Invoke(@(&{$args}%*))}"
  exit /b
#>

# Function to output the message in the right language
function Print-Message {
    param(
        [string]$lang,
        [string]$message
    )
    
    if ($lang -eq $language) {
        Write-Host "$message"
    }
}

# Function to check if Firefox is installed
function Is-FirefoxInstalled {
    return (Test-Path "C:\Program Files\Mozilla Firefox\firefox.exe" -PathType Leaf)
}

# Function to download file
function Download-File {
    param(
        [string]$url,
        [string]$outputFile
    )

    $webClient = New-Object System.Net.WebClient
    $webClient.DownloadFile($url, $outputFile)
}

# Function to install Firefox
function Install-Firefox {
    param(
        [string]$installerPath
    )

    Start-Process -FilePath $installerPath -ArgumentList "/S" -Wait
}

# Prompt user to select language
do {
    $language = Read-Host "Please select the language / Veuillez saisir la langue (en/fr)" -ErrorAction SilentlyContinue
    $language = $language.ToLower()
} until ($language -eq "en" -or $language -eq "fr")

# Main script
if (Is-FirefoxInstalled) {
    Print-Message "en" "Firefox is already installed."
    Print-Message "fr" "Firefox est deja installe."
}
else {
    # Define URLs for latest version of Firefox installer
    $firefoxBaseUrl = "https://download.mozilla.org/?product=firefox-latest&os="
    $osArchitecture = if ([System.Environment]::Is64BitOperatingSystem) { "win64" } else { "win32" }
    $firefoxUrl = $firefoxBaseUrl + $osArchitecture

    # Define download path for Firefox installer
    $downloadPath = "$env:TEMP\FirefoxInstaller.exe"

    # Download Firefox installer
    Print-Message "en" "Downloading Firefox installer from $firefoxUrl ..."
    Print-Message "fr" "Telechargement de l'installeur Firefox depuis $firefoxUrl ..."
    Download-File -url $firefoxUrl -outputFile $downloadPath

    # Install Firefox
    Print-Message "en" "Installing Firefox, please wait ..."
    Print-Message "fr" "Installation de Firefox, veuillez patienter ..."

    # Wait 2 seconds
    Start-Sleep -Seconds 2

    Install-Firefox -installerPath $downloadPath

    # Verify if the installation was successful
    if (Is-FirefoxInstalled) {
        Print-Message "en" "Firefox has been installed successfully."
        Print-Message "fr" "Firefox a ete installe avec succes."
    }
    else {
        Print-Message "en" "An error happened during Firefox installation."
        Print-Message "fr" "Une erreur s'est produite durant l'installation de Firefox."
    }
}

# Pause for 5 seconds
Print-Message "en" "This window will close automatically in 5 seconds ..."
Print-Message "fr" "Cette fenetre se fermera automatiquement dans 5 secondes ..."
Start-Sleep -Seconds 5
